#!/usr/bin/perl

package eBay::API::XML::DataType::DistanceType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. DistanceType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::DistanceType

=head1 DESCRIPTION

DistanceType used in proximity search



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::DistanceType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'DistanceMeasurement', 'xs:int', '', '', '' ]
	, [ 'DistanceUnit', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDistanceMeasurement()

The measurement used in a proximity search distance calculation.

#    Argument: 'xs:int'

=cut

sub setDistanceMeasurement {
  my $self = shift;
  $self->{'DistanceMeasurement'} = shift
}

=head2 getDistanceMeasurement()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

  Calls: GetCategoryListings
         GetProducts
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getDistanceMeasurement {
  my $self = shift;
  return $self->{'DistanceMeasurement'};
}


=head2 setDistanceUnit()

The unit used in a proximity search distance calculation.

#    Argument: 'xs:string'

=cut

sub setDistanceUnit {
  my $self = shift;
  $self->{'DistanceUnit'} = shift
}

=head2 getDistanceUnit()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

  Calls: GetCategoryListings
         GetProducts
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getDistanceUnit {
  my $self = shift;
  return $self->{'DistanceUnit'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
