package Daje::Document::Templates::Base;
use Mojo::Base -base;
use v5.42;


# NAME
# ====
#
#      Daje::Document::Templates::Base - It's the base class for all Daje Document Templates
#
#
# REQUIRES
# ========
#
# use Mojo::Base;
#
# DESCRIPTION
# ===========
#
# Daje::Document::Templates::Base Provides some common methods
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#
#
use Data::Dumper;

has 'subs' => ();

sub insert_sub($self, $tag, $sub) {
    my $subdef->{sub} = $sub;
    $subdef->{tag} = $tag;
    push @{$self->{subs}}, $subdef;

}

sub add_subs($self, $data) {
    $self->set_subs();
    if (exists $self->{subs}) {
        my $length = scalar @{$self->{subs}};
        for (my $i = 0; $i < $length; $i++) {
            my $subdef = @{$self->{subs}}[$i];
            $data->{$subdef->{tag}} = $subdef->{sub};
        }
    }
    return 1;
}
1;

#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


     Daje::Document::Templates::Base - It's the base class for all Daje Document Templates




=head1 DESCRIPTION


Daje::Document::Templates::Base Provides some common methods



=head1 REQUIRES


use Mojo::Base;



=head1 METHODS

=head2 add_subs($self,

 add_subs($self,();

=head2 get_subs_array($self)

 get_subs_array($self)();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>




=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

