use Test2::V0;
use Bitcoin::Crypto qw(btc_transaction);

use lib 't/lib';
use TransactionStore;

my @cases = (
	{
		desc => 'transaction with SIGHASH_SINGLE',
		tx =>
			'02000000000104e5b5819549e2d93193add6ff17dc260ccbe0614b18f3d37ec3c0c1442d4400c50000000000ffffffffe5b5819549e2d93193add6ff17dc260ccbe0614b18f3d37ec3c0c1442d4400c50100000000ffffffff3c8a4de56f29c76132ef87826a13c87ccb3f092c71565c18fdedfa183f4a15200000000000ffffffffe5b5819549e2d93193add6ff17dc260ccbe0614b18f3d37ec3c0c1442d4400c50200000000ffffffff06b0040000000000002251203d9331d806e265a18aef2177974c457ba423a2228c8030810fcb23410b9d86a122020000000000002251203d9331d806e265a18aef2177974c457ba423a2228c8030810fcb23410b9d86a11b13130000000000225120c5f7f49d4177d09042686dcb7651393acc86d71773f53835e6aec1f59b40605458020000000000002251203d9331d806e265a18aef2177974c457ba423a2228c8030810fcb23410b9d86a158020000000000002251203d9331d806e265a18aef2177974c457ba423a2228c8030810fcb23410b9d86a1be720000000000002251203d9331d806e265a18aef2177974c457ba423a2228c8030810fcb23410b9d86a10140954bb65991c333ae41c73fa22bb4e0605b8507e296277f27eae60815eef7e1db5568115f912992305311351d952921b7948e3e8e4e235e19ac52d23aeefd424a01404ca0e10f2a81fc9c84a56bec30aaaf213ec4a32564313c539c12eb6b56dcd9189aaae5c2ba0c2baa2041c23570c057c51f0c6696350887450c70a86be013a5f701411426961d0c3f8dcdd6f3f46de65a5ce19814e13be1cb1b24c93eb565ece74960312cdf8e602c4d0169520bce08f23692a8e93df592fe678869152d770276c280830140d644b808859ff900400602470c5f64552a9a9590d687354d1415a502099b4fb1286907cc0fba1ac0b300779000203f1f351ad59f7e8e2e2fa02ee1a7ad5f3ec900000000'
	},
	{
		desc => 'transaction with tapscript (inscription)',
		tx =>
			'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',
	},
);

foreach my $case (@cases) {
	subtest "should pass for $case->{desc}" => sub {
		ok lives { btc_transaction->from_serialized([hex => $case->{tx}])->verify };
	};
}

done_testing;

